unit [!UnitName];

interface

uses
  System.Drawing,
  System.Collections,
  System.ComponentModel,
  Borland.Eco.Persistence;

type
  T[!ClassName] = class(PersistenceMapperProvider)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  strict private
    procedure DoGenerateDb;
  public
    constructor Create;
    class procedure GenerateDb; static;
    class function get_Instance: T[!ClassName]; static;
    //class procedure RegisterTcpServer(Port: integer); static;
    class property  Instance: T[!ClassName] read get_Instance;
  end;

implementation

uses
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
[!else]
   [!EcoSpaceUnitName],
[!endif]
  System.Globalization;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure T[!ClassName].InitializeComponent;
begin
  Self.Components := System.ComponentModel.Container.Create;
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
[!else]
  //
  // TEcoPersistenceMapperProvider
  //
  Self.EcoSpaceType := TypeOf([!EcoSpaceClassName]);
[!endif]
end;
{$ENDREGION}

constructor T[!ClassName].Create;
begin
  inherited Create;
  InitializeComponent;
end;

procedure T[!ClassName].Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

procedure T[!ClassName].DoGenerateDb;
begin
  PersistenceMapper.CreateDataBaseSchema(GetTypeSystemService(true), DefaultCleanPsConfig.Create(true));
end;

class procedure T[!ClassName].GenerateDb;
begin
   Instance.DoGenerateDb;
end;

class function T[!ClassName].get_Instance: T[!ClassName];
begin
  Result := GetInstance(typeof(T[!ClassName])) as T[!ClassName];
end;

(*
// Sample code for registering the provider as a server using
// binary formatting on a TCP channel.
// add the following to your implementation level uses-statement when uncommenting the code
// System.Runtime.Serialization.Formatters, System.Runtime.Remoting, System.Runtime.Remoting.Channels, System.Runtime.Remoting.Channels.Tcp;

class procedure T[!ClassName].RegisterTcpServer(Port: integer);
var
  provider: BinaryServerFormatterSinkProvider;
  props: IDictionary;
  chan: TcpChannel;
begin
  provider := BinaryServerFormatterSinkProvider.Create;
  provider.TypeFilterLevel := TypeFilterLevel.Full; // Needed for serializations
  props := Hashtable.Create;
  props['port'] := Port;
  chan := TcpChannel.Create(props, nil, provider);
  ChannelServices.RegisterChannel(chan);
  RemotingConfiguration.RegisterWellKnownServiceType(
    typeof(T[!ClassName]),
    'TestServer1',
    WellKnownObjectMode.Singleton);
end;
*)

end.
